/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog;

import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.app.comp.EditableNumericSpinner;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.LogoProperties;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

public class SpacePanel
extends DataInputPanel {
    private static final long serialVersionUID = 1L;
    public final int MAX_DISTANCE = 3000;
    public final int MIN_DISTANCE = 10;
    public final int INCREMENT = 5;
    private JCheckBox fCbxUseAsDefault;
    private static EditableNumericSpinner fSpinnerSpaceDistance;
    private JLabel fLblSpaceDistance;
    public int space;

    public SpacePanel() {
        this.initialize();
        this.loadValuesFromIni();
    }

    public boolean checkFieldContents() {
        if (!fSpinnerSpaceDistance.checkValue(false)) {
            fSpinnerSpaceDistance.requestFocus();
            return false;
        }
        return true;
    }

    public Dimension getPreferredSize() {
        return new Dimension(60, 60);
    }

    public String getTitle() {
        return Language.getString("dialog.space.title", "Spacing");
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = null;
        this.fLblSpaceDistance = new JLabel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.fLblSpaceDistance, gbc);
        fSpinnerSpaceDistance = new EditableNumericSpinner();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        this.add((Component)fSpinnerSpaceDistance, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weighty = 1.0;
        this.add(Box.createGlue(), gbc);
        this.fCbxUseAsDefault = new JCheckBox("Use as default");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        this.add((Component)this.fCbxUseAsDefault, gbc);
    }

    public void loadFieldContents() {
        fSpinnerSpaceDistance.setMax(3000);
        fSpinnerSpaceDistance.setMin(10);
        fSpinnerSpaceDistance.setIncrement(5);
        fSpinnerSpaceDistance.setValue(this.space);
    }

    public void setLabels() {
        this.fLblSpaceDistance.setText(Language.getString("dialog.space.horizontal", "Distance:"));
        Object[] values = new Object[]{new Integer(10), new Integer(3000), new Integer(5)};
        fSpinnerSpaceDistance.setError(new LogoError((Component)fSpinnerSpaceDistance, "error.dialog.invalidValueIncrement", "Please enter an integer between 10 and 3000 in the distance of 5", values, 2, 0));
        this.fCbxUseAsDefault.setText(Language.getString("dialog.useAsDefault"));
    }

    public void storeFieldContents() {
        this.space = fSpinnerSpaceDistance.getValue();
        if (this.fCbxUseAsDefault.isSelected()) {
            this.saveAsDefault();
        }
    }

    public int getSpace() {
        return this.space;
    }

    public void saveAsDefault() {
        LogoProperties logoProperties = LogoProperties.instance();
        logoProperties.setIntProperty("space.distance", this.space);
    }

    private void loadValuesFromIni() {
        LogoProperties logoProperties = LogoProperties.instance();
        this.space = logoProperties.getIntProperty("space.distance", 10);
    }
}

